/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.model;

import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Range;

public class LogSettingInfo {
    private Boolean autoMailEnable;
    @Pattern(regexp="^$|[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,6}", message="Value of 'From Address' should be a correct email address.")
    private String fromAddress;
    @Pattern(regexp="^$|[-0-9a-zA-Z.+_]+@[-0-9a-zA-Z.+_]+\\.[a-zA-Z0-9]{2,6}", message="Value of 'To Address' should be a correct email address.")
    private String toAddress;
    @Pattern(regexp="^$|((\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])(\\.(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])){3}|([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?\\.)+[a-zA-Z]{2,6})", message="Value of 'Mail Server' should be a correct ip or domain.")
    private String server;
    @Range(min=0L, max=65535L, message="Value of 'Port' is from 1 to 65535.")
    private Integer port;
    private Boolean authEnable;
    private String userName;
    private String password;
    private String timeMode;
    @Range(min=0L, max=23L, message="Hour of 'Fixation Time' is from 0 to 23.")
    private Integer fixationTimeH = 0;
    @Range(min=0L, max=59L, message="Minute of 'Fixation Time' is from 0 to 59.")
    private Integer fixationTimeM = 0;
    @Range(min=1L, max=24L, message="Value of 'Period Time' is from 1 to 24.")
    private Integer periodTime = 1;
    private Boolean logClientDetailAMF;
    private Boolean serverEnable;
    @Pattern(regexp="^$|\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b", message="Value of 'Log Server IP' should be a correct ip address.")
    private String logServerIp;
    @Range(min=0L, max=65535L, message="Value of 'Log Server Port' is from 1 to 65535.")
    private Integer logServerPort;
    private Boolean logClientDetailLS;

    public Boolean getAutoMailEnable() {
        return this.autoMailEnable;
    }

    public void setAutoMailEnable(Boolean autoMailEnable) {
        this.autoMailEnable = autoMailEnable;
    }

    public String getFromAddress() {
        return this.fromAddress;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Boolean getLogClientDetailAMF() {
        return this.logClientDetailAMF;
    }

    public void setLogClientDetailAMF(Boolean logClientDetailAMF) {
        this.logClientDetailAMF = logClientDetailAMF;
    }

    public Boolean getAuthEnable() {
        return this.authEnable;
    }

    public void setAuthEnable(Boolean authEnable) {
        this.authEnable = authEnable;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getTimeMode() {
        return this.timeMode;
    }

    public void setTimeMode(String timeMode) {
        this.timeMode = timeMode;
    }

    public Integer getFixationTimeH() {
        return this.fixationTimeH;
    }

    public void setFixationTimeH(Integer fixationTimeH) {
        this.fixationTimeH = fixationTimeH;
    }

    public Integer getFixationTimeM() {
        return this.fixationTimeM;
    }

    public void setFixationTimeM(Integer fixationTimeM) {
        this.fixationTimeM = fixationTimeM;
    }

    public Integer getPeriodTime() {
        return this.periodTime;
    }

    public void setPeriodTime(Integer periodTime) {
        this.periodTime = periodTime;
    }

    public Boolean getServerEnable() {
        return this.serverEnable;
    }

    public void setServerEnable(Boolean serverEnable) {
        this.serverEnable = serverEnable;
    }

    public String getLogServerIp() {
        return this.logServerIp;
    }

    public void setLogServerIp(String logServerIp) {
        this.logServerIp = logServerIp;
    }

    public Integer getLogServerPort() {
        return this.logServerPort;
    }

    public void setLogServerPort(Integer logServerPort) {
        this.logServerPort = logServerPort;
    }

    public Boolean getLogClientDetailLS() {
        return this.logClientDetailLS;
    }

    public void setLogClientDetailLS(Boolean logClientDetailLS) {
        this.logClientDetailLS = logClientDetailLS;
    }

    public String toString() {
        return "LogSettingInfo [autoMailEnable=" + this.autoMailEnable + ", fromAddress=" + this.fromAddress + ", toAddress=" + this.toAddress + ", server=" + this.server + ", port=" + this.port + ", authEnable=" + this.authEnable + ", userName=" + this.userName + ", password=" + this.password + ", timeMode=" + this.timeMode + ", fixationTimeH=" + this.fixationTimeH + ", fixationTimeM=" + this.fixationTimeM + ", periodTime=" + this.periodTime + ", logClientDetailAMF=" + this.logClientDetailAMF + ", serverEnable=" + this.serverEnable + ", logServerIp=" + this.logServerIp + ", logServerPort=" + this.logServerPort + ", logClientDetailLS=" + this.logClientDetailLS + "]";
    }
}

